*-------------------------------------------------------------------------------
/* title : Estimation results for manuscrpit
   input : $temp/Sample.dta and 
		   $temp/Sample_lag_proxies.dta --- used for additonal variables
   output: $output_dta/ .dta files store bootstrap point estimates 
		   $output_dta/ .ster files store estimation results */
*-------------------------------------------------------------------------------

*===============================================================================
* Set up
*===============================================================================
*--------------------------SET-UP & READ DIRECTORIES----------------------------
cd							// Current directory of code
run "[0.0] directories.do" 	// Load directories

*-----------------------------MACROS FOR ESTIMATION-----------------------------
global compet	PC			// Competition in output market: Perfect (PC); Imperfect (IC)
global inputs	PkPl		// Timing assumption for inputs: PkPl(default)=Pre-determined k & Pre-determined l; PkDl=Pre-determined k & Dynamic l; or PkFl=Pre-determined k & Flexible l

*-----------------------MACROS FOR INSTRUMENTAL VARIABLES-----------------------
global IVext   NO			// YES includes external instruments (defined in the macro Instruments); NO (default) use own variable lags to instrument

*-------------------------------MACROS FOR DATA---------------------------------
global indlev	CPA			// Industry classification: CPA (ISIC Rev.4 also in WIOD); nace2 (nace rev.2 2-digit); A38(intermediate aggregation of nace)

*-----------------------------MACROS FOR BOOTSTRAP------------------------------
global seed 	1658203945 	// Set random-# seed for replicability of results
global B		99 			// Bootstrap replications: Efron&Tibsharani(1993) B=200 almost always enough; Davidson&MacKinnon(2002) for a=0.05->B=399 & for a=0.01->B=1499; (Cameron & Trivedi pg.361-362; a(B+1)=integer)
global clust	Ccj			// Variables identifying resampling clusters for bootstraping: id; $indlev country; Cc; Cj; Ccj
global idclust	newCcj 		// Creates a new variable containing a unique identifier for each resampled cluster: newid; newCc; newCj; newCcj
global group	newid 		// Re-creates varname with a unique identifier for each firm across the resampled clusters (including re-sampling the same original cluster): newid

*-------------------------MACROS FOR FIXED-EFFECTS (FE)-------------------------
global FEj 		YES			// Industry: YES or NO
global FEc 		YES			// Country: YES or NO
global FEt 		YES			// Time: YES or NO
global FEjt 	NO			// Industry-time: YES or NO
global FEct 	NO			// Country-time: YES or NO

*-------------------------MACROS FOR LINEAR TIME TRENDS-------------------------
global TREND 	NO			// Time: YES or NO
global TRENDj 	YES			// Industry: YES or NO
global TRENDc 	YES			// Country: YES or NO

*-------------------------------------------------------------------------------

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Baseline - First column in all tables
*===============================================================================
global model Baseline 					// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate and store TFP, output elasticities of inputs and RTS (with original sample)
run "$code/[4.1] TFP.do"

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

*===============================================================================
* Fixed effects ct (country-time) - Table 2; column (2)
*===============================================================================
global model 	FE_ct 					// Name of estimation (also used to save results)

* Macros for FE
global FEc 		NO						// Industry: YES or NO
global FEt 		NO						// Time: YES or NO
global FEct 	YES						// Industry-time: YES or NO
global TRENDc 	NO						// Industry: YES or NO

use "$temp/Sample.dta", clear

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global FEc 		YES						// Industry: YES or NO
global FEt 		YES						// Time: YES or NO
global FEct 	NO						// Industry-time: YES or NO
global TRENDc 	YES						// Industry: YES or NO

*===============================================================================
* Fixed effects jt (industry-time) - Table 2; column (3)
*===============================================================================
global model 	FE_jt 					// Name of estimation (also used to save results)

* Macros for FE
global FEj 		NO						// Industry: YES or NO
global FEt 		NO						// Time: YES or NO
global FEjt 	YES						// Industry-time: YES or NO
global TRENDj 	NO						// Industry: YES or NO

use "$temp/Sample.dta", clear

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global FEj 		YES						// Industry: YES or NO
global FEt 		YES						// Time: YES or NO
global FEjt 	NO						// Industry-time: YES or NO
global TRENDj 	YES						// Industry: YES or NO

*===============================================================================
* Labour Timing - Table 2; column (4)
*===============================================================================
global model 	LabourTiming 			// Name of estimation (also used to save results)
global inputs	PkDl					// Timing assumption for inputs: PkPl(default)=Pre-determined k & Pre-determined l; PkDl=Pre-determined k & Dynamic l; or PkFl=Pre-determined k & Flexible l

use "$temp/Sample.dta", clear

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global inputs	PkPl					// Timing assumption for inputs: PkPl(default)=Pre-determined k & Pre-determined l; PkDl=Pre-determined k & Dynamic l; or PkFl=Pre-determined k & Flexible l

*===============================================================================
* Imperfect Competition - Table 2; column (5)
*===============================================================================
global model 	IC			 			// Name of estimation (also used to save results)
global compet 	$model 					// Competition in output market: Perfect (PC); Imperfect (IC)

use "$temp/Sample.dta", clear

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate and store TFP, output elasticities of inputs and RTS (with original sample)
run "$code/[4.1] TFP.do"

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global compet 	PC 						// Competition in output market: Perfect (PC); Imperfect (IC)

*===============================================================================
* Fix Weights in 2000 for All proxies - Table 2; column (6)
*===============================================================================
global model 	Proxies00 				// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *down0dIM *up0dEX *up0dIM *down0dEX
merge 1:1 newid year using "$temp/Sample_lag_proxies.dta", nogen keep(matched) keepusing(*down0dIM_00 *up0dEX_00 *up0dIM_00 *down0dEX_00)

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM_00 up0dEX_00 up0dIM_00 down0dEX_00 IM EX shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for // Declare key regressors of interest in markov process (excluding persistence term and fixed effects)

*===============================================================================
* Fix Weights in 2000 only for downIM & upEX - Table 2; column (7)
*===============================================================================
global model 	Proxies00downIMupEX		// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *down0dIM *up0dEX 
merge 1:1 newid year using "$temp/Sample_lag_proxies.dta", nogen keep(matched) keepusing(*down0dIM_00 *up0dEX_00)

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM_00 up0dEX_00 up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for // Declare key regressors of interest in markov process (excluding persistence term and fixed effects)

*===============================================================================
* IV (External Insrumental Variables) - Table 4; column (2)
*===============================================================================
global model 	IV						// Name of estimation (also used to save results)
global IVext 	YES						// YES includes external instruments (defined in the macro instruments); NO (default) use own variable lags to instrument

use "$temp/Sample.dta", clear
drop L2_do* L2_up* DL2_down0dIM-DL12_down0dIM DL2_up0dEX-DL12_up0dEX DL2_up0dIM-DL12_up0dIM DL2_down0dEX-DL12_down0dEX L2_IM L2_EX DL2_IM-DL12_IM DL2_EX-DL12_EX
merge 1:1 newid year using "$temp/Sample_lag_proxies.dta", nogen keep(matched) keepusing(*_iv1 *_iv2 *_iv2_0d)

* Declare external instruments
global instruments down0dIM_iv1 up0dEX_iv1 up0dIM_iv1 down0dEX_iv1 IM_iv1 EX_iv1 down0dIM_iv2 up0dEX_iv2 up0dIM_iv2 down0dEX_iv2 IM_iv2_0d EX_iv2_0d IM_iv2 EX_iv2 shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate and store TFP, output elasticities of inputs and RTS (with original sample)
run "$code/[4.1] TFP.do"

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global IVext 	NO						// YES includes external instruments (defined in the macro instruments); NO (default) use own variable lags to instrument

*===============================================================================
* IVnoUS (External Insrumental Variables excluding US) - Table 4; column (3)
*===============================================================================
global model 	IVnoUS					// Name of estimation (also used to save results)
global IVext 	YES						// YES includes external instruments (defined in the macro instruments); NO (default) use own variable lags to instrument

use "$temp/Sample.dta", clear
drop L2_do* L2_up* DL2_down0dIM-DL12_down0dIM DL2_up0dEX-DL12_up0dEX DL2_up0dIM-DL12_up0dIM DL2_down0dEX-DL12_down0dEX L2_IM L2_EX DL2_IM-DL12_IM DL2_EX-DL12_EX
merge 1:1 newid year using "$temp/Sample_lag_proxies.dta", nogen keep(matched) keepusing(*_iv1noUS *_iv2noUS *_iv2_0dnoUS)

* Declare external instruments
global instruments down0dIM_iv1noUS up0dEX_iv1noUS up0dIM_iv1noUS down0dEX_iv1noUS IM_iv1noUS EX_iv1noUS down0dIM_iv2noUS up0dEX_iv2noUS up0dIM_iv2noUS down0dEX_iv2noUS IM_iv2_0dnoUS EX_iv2_0dnoUS IM_iv2noUS EX_iv2noUS shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate and store TFP, output elasticities of inputs and RTS (with original sample)
run "$code/[4.1] TFP.do"

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Reset assumptions to baseline model
global IVext 	NO						// YES includes external instruments (defined in the macro instruments); NO (default) use own variable lags to instrument

*===============================================================================
* Underidentification tests for Baseline model - Table 4; column (1)
*===============================================================================
foreach var in down0dIM up0dEX up0dIM down0dEX {
	global Uvar 	`var' 					// The endogenous variable used to test for weak identification
	global model 	Utest_$Uvar 			// Name of estimation (also used to save results)
	global IVext 	YES						// YES includes external instruments (defined in the macro instruments); NO (default) use own variable lags to instrument

	use "$temp/Sample.dta", clear

	* Auxiliary regression: declare instruments and remaining regressors of interest in markov process (excluding persistence term and fixed effects)
	global instruments $markov 				//Keep the same instrument matrix as in baseline model
	global markov: list global(markov) - global(Uvar) // Exclude the endogenous variable used to test for weak identification

	* Declare regressors, IV and FE
	run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

	* Estimate, bootstrap and store
	run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

	* Reset assumptions to baseline model
	global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for // Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
	global IVext 	NO						// YES includes external instruments (defined in the macro instruments); NO (default) use own variable lags to instrument
	macro drop Uvar 						// The endogenous variable used to test for weak identification
}

*===============================================================================
* Underidentification test for IV model - Table 4; column (2)
*===============================================================================
foreach var in down0dIM up0dEX up0dIM down0dEX {
	global Uvar 	`var' 					// The endogenous variable used to test for weak identification
	global model 	Utest_IV_$Uvar 			// Name of estimation (also used to save results)
	global IVext 	YES						// YES includes external instruments (defined in the macro instruments); NO (default) use own variable lags to instrument

	use "$temp/Sample.dta", clear
	drop L2_do* L2_up* DL2_down0dIM-DL12_down0dIM DL2_up0dEX-DL12_up0dEX DL2_up0dIM-DL12_up0dIM DL2_down0dEX-DL12_down0dEX L2_IM L2_EX DL2_IM-DL12_IM DL2_EX-DL12_EX
	merge 1:1 newid year using "$temp/Sample_lag_proxies.dta", nogen keep(matched) keepusing(*_iv1 *_iv2 *_iv2_0d)
	
	* Auxiliary regression: declare instruments and remaining regressors of interest in markov process (excluding persistence term and fixed effects)
	global instruments down0dIM_iv1 up0dEX_iv1 up0dIM_iv1 down0dEX_iv1 IM_iv1 EX_iv1 down0dIM_iv2 up0dEX_iv2 up0dIM_iv2 down0dEX_iv2 IM_iv2_0d EX_iv2_0d IM_iv2 EX_iv2 shh_dom sub_dom shh_for sub_for 				//Keep the same instrument matrix as in IV model
	global markov: list global(markov) - global(Uvar) // Exclude the endogenous variable used to test for weak identification

	* Declare regressors, IV and FE
	run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

	* Estimate, bootstrap and store
	run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

	* Reset assumptions to baseline model
	global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for // Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
	global IVext 	NO						// YES includes external instruments (defined in the macro instruments); NO (default) use own variable lags to instrument
	macro drop Uvar 						// The endogenous variable used to test for weak identification
}

*===============================================================================
* Underidentification test for IVnoUS model - Table 4; column (3)
*===============================================================================
foreach var in down0dIM up0dEX up0dIM down0dEX {
	global Uvar 	`var' 					// The endogenous variable used to test for weak identification
	global model 	Utest_IVnoUS_$Uvar 		// Name of estimation (also used to save results)
	global IVext 	YES						// YES includes external instruments (defined in the macro instruments); NO (default) use own variable lags to instrument

	use "$temp/Sample.dta", clear
	drop L2_do* L2_up* DL2_down0dIM-DL12_down0dIM DL2_up0dEX-DL12_up0dEX DL2_up0dIM-DL12_up0dIM DL2_down0dEX-DL12_down0dEX L2_IM L2_EX DL2_IM-DL12_IM DL2_EX-DL12_EX
	merge 1:1 newid year using "$temp/Sample_lag_proxies.dta", nogen keep(matched) keepusing(*_iv1noUS *_iv2noUS *_iv2_0dnoUS)
	
	* Auxiliary regression: declare instruments and remaining regressors of interest in markov process (excluding persistence term and fixed effects)
	global instruments down0dIM_iv1noUS up0dEX_iv1noUS up0dIM_iv1noUS down0dEX_iv1noUS IM_iv1noUS EX_iv1noUS down0dIM_iv2noUS up0dEX_iv2noUS up0dIM_iv2noUS down0dEX_iv2noUS IM_iv2_0dnoUS EX_iv2_0dnoUS IM_iv2noUS EX_iv2noUS shh_dom sub_dom shh_for sub_for 				//Keep the same instrument matrix as in IVnoUS model
	global markov: list global(markov) - global(Uvar) // Exclude the endogenous variable used to test for weak identification

	* Declare regressors, IV and FE
	run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

	* Estimate, bootstrap and store
	run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

	* Reset assumptions to baseline model
	global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for // Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
	global IVext 	NO						// YES includes external instruments (defined in the macro instruments); NO (default) use own variable lags to instrument
	macro drop Uvar 						// The endogenous variable used to test for weak identification
}

*===============================================================================
* Domestic Links - Table 5; column (2)
*===============================================================================
global model 	DomesticLinks_D			// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Foreign owned firms with no domestic ownership
merge 1:1 newid year using "$temp/Sample_lag_proxies.dta", nogen keep(matched) keepusing(D *_D)

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX down0dIM_D up0dEX_D up0dIM_D down0dEX_D D IM EX IM_D EX_D shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Relatively Downstream - Table 5; column (3)
*===============================================================================
global model 	Downstream_D			// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Define relatively downstream industries
gen D = 0
replace D = 1 if inlist(CPA, 12, 22, 21, 17, 20, 6, 5, 19, 18)

* Generate relevant lags of interactions terms (note: D is time-invariant)
xtset newid year
foreach var of varlist down0dIM up0dEX up0dIM down0dEX IM EX {
	* Lags
	qui forvalues i = 1/2 {
		gen L`i'_`var'_D = L`i'_`var'*D 
	}
	
	* First-differences
	qui forvalues i = 1/12 {
		 gen DL`i'_`var'_D = DL`i'_`var'*D
	}
}

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX down0dIM_D up0dEX_D up0dIM_D down0dEX_D IM EX IM_D EX_D shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Relatively Low-tech - Table 5; column (4)
*===============================================================================
global model 	LowTech_D				// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Define relatively low-tech industries
* See High&Medium-High&Medium-Low-Tech industries in: http://ec.europa.eu/eurostat/statistics-explained/index.php?title=Glossary:High-tech
gen D = 1
replace D = 0 if inlist(CPA, 12, 17, 11, 18, 19, 20, 21, 10, 13, 14, 15, 16, 23)

* Generate relevant lags of interactions terms (note: D is time-invariant)
xtset newid year
foreach var of varlist down0dIM up0dEX up0dIM down0dEX IM EX {
	* Lags
	qui forvalues i = 1/2 {
		gen L`i'_`var'_D = L`i'_`var'*D 
	}
	
	* First-differences
	qui forvalues i = 1/12 {
		 gen DL`i'_`var'_D = DL`i'_`var'*D
	}
}

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX down0dIM_D up0dEX_D up0dIM_D down0dEX_D IM EX IM_D EX_D shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Relatively Labour Intensive - Table 5; column (5)
*===============================================================================
global model 	L_D						// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Define relatively labour intensive industries
gen D = 0
replace D = 1 if inlist(CPA, 5, 6, 7, 9, 15, 16, 21, 22, 23)

* Generate relevant lags of interactions terms (note: D is time-invariant)
xtset newid year
foreach var of varlist down0dIM up0dEX up0dIM down0dEX IM EX {
	* Lags
	qui forvalues i = 1/2 {
		gen L`i'_`var'_D = L`i'_`var'*D 
	}
	
	* First-differences
	qui forvalues i = 1/12 {
		 gen DL`i'_`var'_D = DL`i'_`var'*D
	}
}

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX down0dIM_D up0dEX_D up0dIM_D down0dEX_D IM EX IM_D EX_D shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Relatively Downstream and Low-Tech - Table 5; column (6)
*===============================================================================
global model 	DownstreamLowTech_D		// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Define relatively downstream and labour intensive industries
gen D = 0
replace D = 1 if inlist(CPA, 12, 22, 21, 17, 20, 6, 5, 19, 18) 					 // Relatively Downstream
replace D = 0 if inlist(CPA, 12, 17, 11, 18, 19, 20, 21, 10, 13, 14, 15, 16, 23) // Relatively High&Medium-High&Medium-Low-Tech

* Generate relevant lags of interactions terms (note: D is time-invariant)
xtset newid year
foreach var of varlist down0dIM up0dEX up0dIM down0dEX IM EX {
	* Lags
	qui forvalues i = 1/2 {
		gen L`i'_`var'_D = L`i'_`var'*D 
	}
	
	* First-differences
	qui forvalues i = 1/12 {
		 gen DL`i'_`var'_D = DL`i'_`var'*D
	}
}

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX down0dIM_D up0dEX_D up0dIM_D down0dEX_D IM EX IM_D EX_D shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Relatively Downstream and Labour intensive - Table 5; column (7)
*===============================================================================
global model 	DownstreamL_D			// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Define relatively downstream and labour intensive industries
gen D = 0
replace D = 1 if inlist(CPA, 12, 22, 21, 17, 20, 6, 5, 19, 18) 		// Relatively Downstream
replace D = 0 if inlist(CPA, 8, 10, 11, 12, 13, 14, 17, 18, 19, 20) // Relatively Capital Intensive

* Generate relevant lags of interactions terms (note: D is time-invariant)
xtset newid year
foreach var of varlist down0dIM up0dEX up0dIM down0dEX IM EX {
	* Lags
	qui forvalues i = 1/2 {
		gen L`i'_`var'_D = L`i'_`var'*D 
	}
	
	* First-differences
	qui forvalues i = 1/12 {
		 gen DL`i'_`var'_D = DL`i'_`var'*D
	}
}

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX down0dIM_D up0dEX_D up0dIM_D down0dEX_D IM EX IM_D EX_D shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* CEEC (firms Central Eastern European Countries) - Table 6; column (2)
*===============================================================================
global model 	CEEC_D					// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear

* Define firms in Central Eastern European Countries
gen D = 0 																		// Western European Countries
replace D = 1 if inlist(country, "BG", "CZ", "EE", "HR", "HU", "PL", "RO", "SI", "SK")

* Generate relevant lags of interactions terms (note: D is time-invariant)
xtset newid year
foreach var of varlist down0dIM up0dEX up0dIM down0dEX IM EX {
	* Lags
	qui forvalues i = 1/2 {
		gen L`i'_`var'_D = L`i'_`var'*D 
	}
	
	* First-differences
	qui forvalues i = 1/12 {
		 gen DL`i'_`var'_D = DL`i'_`var'*D
	}
}

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX down0dIM_D up0dEX_D up0dIM_D down0dEX_D IM EX IM_D EX_D shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Split Proxies developed vs developing for CEEC - Table 6; columns (3a) & (3b)
*===============================================================================
global model 	Developed_Split_CEEC	// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *down0dIM *up0dEX *up0dIM *down0dEX *IM *EX
keep if inlist(country, "BG", "CZ", "EE", "HR", "HU", "PL", "RO", "SI", "SK") 	// Keep CEEC countries

* Foreign owned firms with no domestic ownership
merge 1:1 newid year using "$temp/Sample_lag_proxies.dta", nogen keep(matched) keepusing(*IM_dvlpd *EX_dvlpd *IM_dvlpng *EX_dvlpng)

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM_dvlpd up0dEX_dvlpd up0dIM_dvlpd down0dEX_dvlpd down0dIM_dvlpng up0dEX_dvlpng up0dIM_dvlpng down0dEX_dvlpng IM_dvlpd EX_dvlpd IM_dvlpng EX_dvlpng shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for

*===============================================================================
* Split Proxies developed vs developing for WEC - Table 6; columns (4a) & (4b)
*===============================================================================
global model 	Developed_Split_WEC		// Name of estimation (also used to save results)

use "$temp/Sample.dta", clear
drop *down0dIM *up0dEX *up0dIM *down0dEX *IM *EX
drop if inlist(country, "BG", "CZ", "EE", "HR", "HU", "PL", "RO", "SI", "SK") 	// Drop CEEC countries

* Foreign owned firms with no domestic ownership
merge 1:1 newid year using "$temp/Sample_lag_proxies.dta", nogen keep(matched) keepusing(*IM_dvlpd *EX_dvlpd *IM_dvlpng *EX_dvlpng)

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM_dvlpd up0dEX_dvlpd up0dIM_dvlpd down0dEX_dvlpd down0dIM_dvlpng up0dEX_dvlpng up0dIM_dvlpng down0dEX_dvlpng IM_dvlpd EX_dvlpd IM_dvlpng EX_dvlpng shh_dom sub_dom shh_for sub_for

* Declare regressors, IV and FE
run "$code/[4.1] regressors_IV_FE.do" 	// Set macros for regressors in markov process, the respective instrumental variables (IV) and fixed effects (FE)

* Estimate, bootstrap and store
run "$code/[4.2] program_bootstrap.do" 	// Program to estimate relevant parameters for original & bootstrap sample, and bootstrapped standard errors

* Declare key regressors of interest in markov process (excluding persistence term and fixed effects)
global markov down0dIM up0dEX up0dIM down0dEX IM EX shh_dom sub_dom shh_for sub_for
